//All the code is found here and can be edited.



#pragma rtGlobals=1		// Use modern global access method.

Function DWS_PanelSetVarProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	SVAR sam= root:P:gsam
		if (cmpstr(sam,"---")==0 || strlen(sam)<=0)
		Abort "Data not selected properly"
	endif
	NVAR redo=root:P:redo
	NVAR 	drop= root:P:drop
	NVAR updrop=root:P:updrop
	redo=2


	SVAR sampath=root:P:gsam
	setdatafolder sampath
	SVAR basename
	string rsample_N="r"+basename+"_avg_N";string qsample_N="q"+basename+"_avg_N";string ssample_N="s"+basename+"_avg_N"
	string rsample_N_B="r"+basename+"_avg_N_B";string qsample_N_B="q"+basename+"_avg_N_B";string ssample_N_B="s"+basename+"_avg_N_B"
	string rsample_avg="r"+basename+"_avg";string qsample_avg="q"+basename+"_avg";string ssample_avg="s"+basename+"_avg"
	wave rsam_N_B=$rsample_N_B;wave ssam_N_B=$qsample_N_B;wave qsam_N_B=$ssample_N_B
	wave rsam_N=$rsample_N;wave ssam_N=$qsample_N;wave qsam_N=$ssample_N
	wave rsam_avg=$rsample_avg;wave ssam_avg=$qsample_avg;wave qsam_avg=$ssample_avg
	
	
	if (exists("rank")==0)
		variable/g rank =numpnts(rsam_N_B)
	endif
	NVAR rank	;variable newdrop
	if (cmpstr("Drop",ctrlName)==0)
		drop=varNum//Str2num (varStr)
		checkbox redo,value=1,win=Image_Analysis_Panel
		newdrop= numpnts(rsam_N_B) -(rank-(drop+updrop))
		DeletePoints  0, newdrop, rsam_N_B,qsam_N_B,ssam_N_B
		DeletePoints  0, newdrop, rsam_avg,qsam_avg,ssam_avg
		DeletePoints  0, newdrop, rsam_N,qsam_N,ssam_N
	endif
		if (cmpstr("upDrop",ctrlName)==0)
		updrop=varNum//Str2num (varStr)
		checkbox redo,value=1,win=Image_Analysis_Panel
		newdrop= numpnts(rsam_N_B) -(rank-(updrop+drop))
		variable npts=numpnts(rsam_N_B)
		variable start=npts-newdrop
		DeletePoints  start, newdrop, rsam_N_B,qsam_N_B,ssam_N_B
		DeletePoints  start, newdrop, rsam_avg,qsam_avg,ssam_avg
		DeletePoints  start, newdrop, rsam_N,qsam_N,ssam_N
	endif
	
end




Function DWSP_InputPanelButtonProc(ctrlName) : ButtonControl
	String ctrlName
	
	if (cmpstr(ctrlName,"LoadMPA")==0)
		execute "LoadMPA()"
		abort
	endif	
		if (cmpstr(ctrlName,"LoadImage")==0)
		execute "LoadIMAGE()"
		abort
	endif	
	if (cmpstr(ctrlName,"Azamuthal")==0)
		execute "Azumuthal_Analysis_Setup()"
		abort
	endif
	
		
	string cmd 
	SVAR sam= root:P:gsam
	SVAR mt=root:P:gmt
	SVAR sens=root:P:gsen
	SVAR dark=root:P:gdark
	SVAR mask=root:P:gmask
	NVAR qmask=root:P:qmask	
	string iwave
	string rwave
	string qwave
	
	if (cmpstr(ctrlName,"Makemask")==0)
		cmd="makemask()//(\""+sens+"\",\""+sam+"\",\""+dark+"\",\""+mt+"\",\""+sens+"\","+num2str(50)+",\"imask\")"
		execute cmd
		abort
	endif
	
	if (cmpstr(ctrlName,"Hardware")==0)
		execute "getspecs()"
		abort
	endif
	
	if (cmpstr(ctrlName,"LoadMPA")==0)
		execute "LoadMPA()"
		abort
	endif	
	if (cmpstr(ctrlName,"LoadImage")==0)
		execute "LoadIMAGE()"
		abort
	endif	
	if (cmpstr(ctrlName,"LoadORDELLA")==0)
		execute "load2dORNL_Ordella(2)"
		abort
	endif	

	
	if (cmpstr(ctrlName,"LoadData")==0)
		execute "Load2dData()"
		abort
	endif
	
	
	if (cmpstr(sam,"---")==0 || strlen(sam)<=0)
		Abort "Data not selected properly"
	endif
	setdatafolder sam
	
	
	if (cmpstr(ctrlName,"Mancent")==0)
	ShowInfo
		variable/g xcenterlcl,ycenterlcl
		NVAR xc=xcenterlcl
		NVAR yc=ycenterlcl
		NVAR xcg=root:Packages:SAS_Modeling:HC
		NVAR ycg=root:Packages:SAS_Modeling:VC
		
		if (stringmatch(CsrInfo(a ), "" ))
		
			DoAlert 0, "Cursor a is not on the image, cmd-I"
			abort
		endif
		xc=hcsr(a)
		xcg=hcsr(a)
		yc=vcsr(a)
		ycg=vcsr(a)
		DrawCenter_AZ()
		
	endif
		if (cmpstr(ctrlName,"areabutton")==0)
		execute "arearq()"
	endif

	if (cmpstr(ctrlName,"Plot2d")==0)
		//execute "Make2DImage(\"\",1)"
		string/g basename
		NVAR qlog=root:Packages:Convert2Dto1D:qlog
		make2Dimage_blind("i"+basename, qlog)
		if (qmask==1)
			Maskimage(1)
		endif
	endif
		if (cmpstr(ctrlName,"Mask")==0)
		Maskimage(1)
	endif
		if (cmpstr(ctrlName,"Unmask")==0)
		MaskImage(0)
	endif
	
	if (cmpstr(ctrlName,"Plotall")==0)
		execute "plotall1(root:P:gsam, root:P:gmt)"
	endif
	
	if (cmpstr(ctrlName,"AddNB")==0)
		SVAR basename
		rwave="r"+basename+"_avg_N_B"
		qwave="q"+basename+"_avg_N_B"
		wave/z rwv=$rwave
		if (!waveexists(rwv))
			Doalert 0,"Wave does not exist"
		else
			execute "SimpleAddtoLogLogPlot(\""+qwave+"\",\""+rwave+"\",\"top\")"
			execute "ChangetoLineandPoints(4,1)"
		endif
	endif
	
	if (cmpstr(ctrlName,"Addcor")==0)
	SVAR basename=basename
		rwave="r"+basename+"_cor_avg"
		qwave="q"+basename+"_cor_avg"
		wave/z rwv=$rwave
		if (!waveexists(rwv))
			Doalert 0,"Wave does not exist"
		else
			execute "SimpleAddToLogLogPlot(\""+qwave+"\",\""+rwave+"\",\"top\")"
		endif
	endif
	
	if (cmpstr(ctrlName,"AvgCor")==0)
		NVAR Wavelength=root:P:wavelengthvalue
		If(wavelength==0)
			getspecs()
		endif
		cmd ="FullAnalysis(root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark,root:P:gmask,root:P:qmask,root:P:redo)"

		execute cmd
	
	endif

	if ((cmpstr(ctrlName,"Correct2d")==0)||(cmpstr(ctrlName,"CorAvg")==0))
		 cmd="CorrectDWS(root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark,root:P:gmask,root:P:qmask,\"i\")"
		execute cmd
	endif
	
	if ((cmpstr(ctrlName,"Average")==0)||(cmpstr(ctrlName,"CorAvg")==0))		
		NVAR ycenter=root:P:gycenter
		NVAR xcenter=root:P:gxcenter
		NVAR topcut=root:P:gtopcut
		NVAR rightcut=root:P:grightcut
		NVAR sdd=root:P:gsdd
		NVAR drop=root:P:drop
		NVAR updrop=root:P:updrop
		NVAR PixelSize=root:P:gpixelsize
		NVAR qmask=root:P:qmask
		NVAR wavelengthvalue=root:P:gwavelengthvalue
		If ((sdd==0)||(ycenter==0)||(rightcut==0)||(topcut==0))
			execute "getspecs()"
		endif
		SVAR basename=basename
		iwave="i"+basename+"_cor"
		 cmd = "Average2DImage(\""+iwave+"\","+num2str (xcenter)+","+num2str (ycenter)+","+num2str (sdd)+","+num2str (pixelsize)+","+num2str (drop)+","+num2str (updrop)+","+num2str (qmask)+")"	
		execute cmd
	endif
	
	if ((cmpstr(ctrlName,"Plotit")==0)||(cmpstr(ctrlName,"CorAvg")==0))
	NVAR absI=absI
	SVAR basename=basename
		 rwave="r"+basename+"_cor_avg"
		qwave="q"+basename+"_cor_avg"
		wave/z rwv=$rwave
		if (!waveexists(rwv))
			Doalert 0,"Wave does not exist"
		else
			 execute "SimpleLogLogPlot(\""+qwave+"\",\""+rwave+"\",\"idplot\")"
		
			If (absi==1)
				Label left "\\F'Helvetica'\\Z18Counts/pixel/hr/cm"
			endif
		endif
	endif
	

	
	if (cmpstr(ctrlName,"FindCenter")==0)
		//SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		//setdatafolder DFloc
		
		wave itemp
		variable N=Dimsize(itemp, 0 )/2
	
		silent 1
		GetMarquee left,top
		if(v_flag==0)
			doalert 0, "Make marquee on graph and press Find Center"
			abort
		endif
		Variable top,bottom,left,right
		top=v_top;bottom=v_bottom;left=v_left;right=v_right
	Fitto2DGaussian_AZ(left,right,bottom,top,"itemp",1000,xc,yc,N)
	SVAR sam=root:P:gsam
	setdatafolder $sam
	NVAR xc=xcenterlcl
	NVAR yc=ycenterlcl
	DrawCenter_AZ()
	
	Endif
	
	if (cmpstr(ctrlName,"showcenter")==0)
		//SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		//setdatafolder DFloc
		NVAR	HCglobal=root:Packages:SAS_Modeling:HC
		If (!NVAR_Exists(HCglobal))
			Doalert 0,"You havenot found the center yet"
			abort
		else
			dowindow/F Azamuthal
			DrawCenter_AZ()
		endif
		
	endif
	
	if ((cmpstr(ctrlName,"PlotLog")==0)||(cmpstr(ctrlName,"Sector")==0))//(cmpstr(ctrlName,"Azamuthal")==0)|
		SVAR DFInt=root:Packages:SAS_Modeling:IntensityWaveName
		SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder DFloc
	//Wave w=$(DFloc+DFint)
		NVAR qlog=root:Packages:Convert2Dto1D:qlog
		Make2DImage_blind((DFloc+DFint), qlog)//(DFint,0)
	endif

	
	if (cmpstr(ctrlName,"DummyWaves")==0)
		execute "Make1and0images()"
		abort
	endif
end


Macro load2dData()
	setdatafolder root:
	String name="iPEFilm"
	silent 1			
	NewdataFolder/O/S $name
	LoadWave/G/M/Q/D/A=wave/L={0,1,64,0,0} //loads 2d wave0 as  matrix	
	make/o/n=(64,64) $name=wave0
	killwaves wave0
	//Plot the log of the image
	duplicate/o $name,itemp
	itemp=log(itemp)
	Display/k=1;AppendImage itemp;DelayUpdate
	ModifyImage itemp ctab= {*,*,YellowHot,0}
	ModifyGraph width=288,height=288
	TextBox/C/N=text0/A=MT name
end


Function DWSP_SetVarProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	SVAR DFloc=root:Packages:SAS_Modeling:DataFolderName
	
	NVAR 	RingCenterPixel= root:Packages:SAS_Modeling:RingCenterPixel
	NVAR 	PixelHalfWidth= root:Packages:SAS_Modeling:PixelHalfWidth
	NVAR     AngHW=root:Packages:SAS_Modeling:AngHW
	NVAR     AngCent=root:Packages:SAS_Modeling:AngCent
	NVAR    HC=root:Packages:SAS_Modeling:HC
	NVAR	VC=root:Packages:SAS_Modeling:VC
	NVAR	Nopnts=root:Packages:SAS_Modeling:Nopnts
	NVAR	Orientation=root:Packages:SAS_Modeling:Orientation
	NVAR	Fold=root:Packages:SAS_Modeling:Fold
	NVAR	SectorMinPixel=root:Packages:SAS_Modeling:SectorMinPixel
	NVAR	SectorMaxPixel=root:Packages:SAS_Modeling:SectorMaxPixel
	variable Hermans
if (cmpstr("UNICAT_Orientation",ctrlName)==0)
	if(cmpstr(DFloc,"---")==0)
			Abort "Data not selected properly"
	endif
	setdatafolder DFloc		
		wave rwave
		NVAR Orientation =root:Packages:SAS_Modeling:Orientation
		Orientation=Str2num (varStr)
		HermansPlot("AnisoIntensityCorr","sa")
		variable HermansValue
		HermansValue =HermansUniaxial(AnisoIntensityCorr,foldedxwave,0)//alwasy do Hermans on folded wave  // ** Pan change 0 to 1, solving the no X axis label showing problem
		
		TextBox/C/W=Azplot/A=MC/N=hermans "f = "+num2str(hermansValue) + " at orientation=("+num2str(orientation)+")"  // ** Pan add " at orientation=("+num2str(orientation)+")" 
		dowindow/F UNICAT_Azamuthal_Panel
		String SampleNote=note(AnisoIntensityCorr)		
		Samplenote= ReplaceNumberByKey("Hermans", Samplenote, HermansValue)
		Samplenote= ReplaceNumberByKey("AZ_orientation", Samplenote, Orientation)
		Note/K AnisoIntensityCorr
		Note AnisoIntensityCorr, Samplenote
		CurveFit/q poly (3+(!fold)*5), AnisoIntensityCorr /X=plotxwave /D
		appendtograph/W=AzPlot fit_AnisoIntensityCorr
	
	//TextBox/C/N=hermansf/A=RT "f = "+num2str(hermans)
	endif


	if (cmpstr("Orientation",ctrlName)==0)
		wave xwave=$(dfloc+"xwave")
		wave shiftedxwave=$(dfloc+"shiftedxwave")
		wave rotatedxwave=$(dfloc+"rotatedxwave")
		wave foldedxwave=$(dfloc+"foldedxwave")
		wave plotxwave=$(dfloc+"plotxwave")
		Orientation=Str2num (varStr)
		//plotxwave=(foldedxwave*fold)+rotatedxwave*(!fold)
		Hermans =HermansUniaxial(rwave,foldedxwave,1)//alwasy do Hermans on folded wave  // ** Pan change 0 to 1, solving the no X axis label showing problem
		TextBox/C/W=Azplot/A=MC/N=hermans "f = "+num2str(hermans) + " at orientation=("+num2str(orientation)+")"  // ** Pan add " at orientation=("+num2str(orientation)+")" 
	endif
	if (cmpstr("SectorMaxPixel",ctrlName)==0)
		SectorMaxPixel=Str2num (varStr)
	endif
	if (cmpstr("SectorMinPixel",ctrlName)==0)
		SectorMinPixel=Str2num (varStr)
	endif
	if (cmpstr("RingCenterPixel",ctrlName)==0)
		RingCenterPixel=Str2num (varStr)
	endif
	if (cmpstr("PixelHalfWidth",ctrlName)==0)
		PixelHalfWidth=Str2num (varStr)
	endif
	if (cmpstr("AngCent",ctrlName)==0)
		AngCent=Str2num (varStr)
	endif
	if (cmpstr("AngHW",ctrlName)==0)
		AngHW=Str2num (varStr)
	endif	
	if (cmpstr("HClocal",ctrlName)==0)
		HC=Str2num (varStr)
		NVAR xcenterlcl
		xcenterlcl=varNum
	endif
	if (cmpstr("VClocal",ctrlName)==0)
		VC=varNum
		NVAR ycenterlcl
		Ycenterlcl=varNum
		
	endif
	if (cmpstr("Nopnts",ctrlName)==0)
		Nopnts=varNum
		
	endif
End




Function DWSP_InputPanelCheckboxProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	NVAR UseQRSData=root:Packages:SAS_Modeling:UseQRSData
		SVAR Dtf=root:Packages:SAS_Modeling:DataFolderName
		SVAR IntDf=root:Packages:SAS_Modeling:IntensityWaveName
		SVAR QDf=root:Packages:SAS_Modeling:QWaveName
		SVAR EDf=root:Packages:SAS_Modeling:ErrorWaveName
		NVAR Fold=root:Packages:SAS_Modeling:Fold
		NVAR SmallMon=root:Packages:SAS_Modeling:SmallMon
		
	NVAR UseIndra2Data=root:packages:GeneralplottingTool:UseIndra2Data
	NVAR UseQRSDATA=root:packages:GeneralplottingTool:UseQRSData
	NVAR UseResults=root:packages:GeneralplottingTool:UseResults
	NVAR UseAniso=root:packages:GeneralplottingTool:UseAniso
	NVAR iWavesOnly=root:packages:GeneralPlottingTool:iWavesOnly

	string oldDf=GetDataFolder(1)
	
	if (cmpstr(ctrlName,"SmallMon")==0)	
		SmallMon=checked
	Endif
	
	if (cmpstr(ctrlName,"Fold")==0)	
		Fold=checked
		wave AnisoIntensityCorr;wave sa
		HermansPlot("AnisoIntensityCorr","sa")
		HermansUniaxial(AnisoIntensityCorr, foldedxwave,1)
	Endif
			
	if (cmpstr(ctrlName,"Useiwaves")==0)	
		if (checked)
			UseIndra2Data=0
			UseQRSdata=0
		endif
		iwavesonly=checked
	endif
	
	if (cmpstr(ctrlName,"UseQRSData")==0)
		UseQRSData=checked
		if (checked)
			UseIndra2Data=0
			iwavesonly=0
		endif
	endif
end

Function DrawCenter_AZ()
	
	NVAR	y=root:Packages:SAS_Modeling:VC
	NVAR	x=root:Packages:SAS_Modeling:HC
	getwindow kwtopwin,hook //sets s_value to the topwindow's name...kwtopwin
	setdrawenv fillpat=0,xcoord=top,ycoord=left,save//try bottom insteat of top

	string centers
	centers="xcent = "+num2str(x)+"\rycnet = "+num2str(y)//ORNL starts with 1 not 0
	TextBox/C/N=centerbox/A=MB centers
	SetDrawEnv linefgc=(65535, 65535, 65535 )
	SetDrawEnv linethick=2
	DrawOval x-3, y+3, x+3, y-3
	
	SetDrawEnv linefgc=(65535, 65535, 65535 )
	SetDrawEnv linethick=2
	DrawOval x-20, y+20, x+20, y-20
	SetDrawEnv linefgc=(65535, 65535, 65535 )
	SetDrawEnv linethick=2
	
	DrawOval x-100, y+100, x+100, y-100
	SetDrawEnv linefgc=(65535, 65535, 65535 )
	SetDrawEnv linethick=2
	DrawOval x-2, y+2, x+2, y-2
EndMacro

function Fitto2DGaussian_AZ(left,right,bottom,top,wavename,PeakInt,xcenter,ycenter,stddev)
	Variable left,right,bottom,top
	variable PeakInt,xcenter,ycenter,stddev
	string wavename
	Prompt wavename,"image? (Use data browser):",popup,WaveList("*", ";","WIN:")
	Prompt left,"Enter the starting x position:"
	Prompt right,"Enter the end x position:"
	Prompt bottom,"Enter the starting y position:"
	Prompt top,"Enter the end y position:"
	Prompt peakInt,"Starting Peak Intensity(1000):"
	Prompt xcenter,"Starting x center pixel(32):"
	Prompt ycenter,"Starting y center pixel(32):"
	Prompt stddev,"Starting Peak width in Pixels(150):"
	
	Silent 1
	Make/o/n=4 gw2DGaussian
	gw2DGaussian[0]=PeakInt;gw2DGaussian[1]=xcenter;:gw2DGaussian[2]=ycenter;gw2DGaussian[3]=stddev
	FuncFitMD gaussian2D_AZ,gw2DGaussian, $waveName(left,right)(bottom, top) //d //Pointing at wrong folder.  Use data browser.
	print gw2DGaussian[0]
	peakInt=gw2DGaussian[0];xcenter=gw2DGaussian[1];ycenter=gw2DGaussian[2];stddev=gw2DGaussian[3]
	string centers
	centers="xcent = "+num2str(xcenter)+"\rycnet = "+num2str(ycenter)//ORNL starts with 1 not 0
	TextBox/C/N=centerbox/A=MB centers
	killwaves/Z gw2DGaussian,W_ParamConfidenceInterval,W_sigma
	NVAR HC=root:Packages:SAS_Modeling:HC;NVAR VC=root:Packages:SAS_Modeling:VC
	NVAR xcenterlcl;NVAR ycenterlcl
	HC=xcenter;xcenterlcl=xcenter
	VC=ycenter;ycenterlcl=ycenter
Endmacro

Function Gaussian2D_AZ(w,x1,y1)
	Wave w;Variable x1 , y1//x is chann
	variable out
	out=(w[0]*exp(-((x1-w[1])^2+(y1-w[2])^2)/w[3]^2))
	return out
end
